package com.ejie.ab04b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.dao.ApartadoAnexoIDao;
import com.ejie.ab04b.model.ApartadoAnexoI;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Ab04b73s00ServiceImpl generated by UDA, 11-Jan-2017 12:23:08.
 * 
 * @author UDA
 */

@Service(value = "ab04b73s00Service")
public class ApartadoAnexoIServiceImpl implements ApartadoAnexoIService {

	@Autowired()
	private ApartadoAnexoIDao ab04b73s00Dao;

	/**
	 * Inserts a single row in the Ab04b73s00 table.
	 * 
	 *  ab04b73s00
	 *            Ab04b73s00
	 *  Ab04b73s00
	 *
	 * @param ab04b73s00 the ab 04 b 73 s 00
	 * @return the apartado anexo I
	 */
	@Transactional(rollbackFor = Throwable.class)
	public ApartadoAnexoI add(ApartadoAnexoI ab04b73s00) {
		return this.ab04b73s00Dao.add(ab04b73s00);
	}

	/**
	 * Updates a single row in the Ab04b73s00 table.
	 * 
	 *  ab04b73s00
	 *            Ab04b73s00
	 *  Ab04b73s00
	 *
	 * @param ab04b73s00 the ab 04 b 73 s 00
	 * @return the apartado anexo I
	 */
	@Transactional(rollbackFor = Throwable.class)
	public ApartadoAnexoI update(ApartadoAnexoI ab04b73s00) {
		return this.ab04b73s00Dao.update(ab04b73s00);
	}

	/**
	 * Finds a single row in the Ab04b73s00 table.
	 * 
	 *  ab04b73s00
	 *            Ab04b73s00
	 *  Ab04b73s00
	 *
	 * @param ab04b73s00 the ab 04 b 73 s 00
	 * @return the apartado anexo I
	 */
	public ApartadoAnexoI find(ApartadoAnexoI ab04b73s00) {
		return (ApartadoAnexoI) this.ab04b73s00Dao.find(ab04b73s00);
	}

	/**
	 * Deletes a single row in the Ab04b73s00 table.
	 * 
	 *  ab04b73s00
	 *            Ab04b73s00
	 *
	 * @param ab04b73s00 the ab 04 b 73 s 00
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(ApartadoAnexoI ab04b73s00) {
		this.ab04b73s00Dao.remove(ab04b73s00);
	}

	/**
	 * Finds a list of rows in the Ab04b73s00 table.
	 * 
	 *  ab04b73s00
	 *            Ab04b73s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<Ab04b73s00>
	 *
	 * @param ab04b73s00 the ab 04 b 73 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	public List<ApartadoAnexoI> findAll(ApartadoAnexoI ab04b73s00, JQGridRequestDto jqGridRequestDto) {
		return (List<ApartadoAnexoI>) this.ab04b73s00Dao.findAll(ab04b73s00, jqGridRequestDto);
	}

	/**
	 * Finds rows in the Ab04b73s00 table using like.
	 * 
	 *  ab04b73s00
	 *            Ab04b73s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<Ab04b73s00>
	 *
	 * @param ab04b73s00 the ab 04 b 73 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<ApartadoAnexoI> findAllLike(ApartadoAnexoI ab04b73s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		return (List<ApartadoAnexoI>) this.ab04b73s00Dao.findAllLike(ab04b73s00, jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the Ab04b73s00 table.
	 * 
	 *  filterAb04b73s00
	 *            Ab04b73s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *
	 * @param filterAb04b73s00 the filter ab 04 b 73 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 */
	public void removeMultiple(ApartadoAnexoI filterAb04b73s00, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		this.ab04b73s00Dao.removeMultiple(filterAb04b73s00, jqGridRequestDto, startsWith);
	}

	/**
	 * Filter method in the Ab04b73s00 table.
	 * 
	 *  filterAb04b73s00
	 *            Ab04b73s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  JQGridResponseDto<Ab04b73s00>
	 *
	 * @param filterAb04b73s00 the filter ab 04 b 73 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<ApartadoAnexoI> filter(ApartadoAnexoI filterAb04b73s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		List<ApartadoAnexoI> listaAb04b73s00 = this.ab04b73s00Dao.findAllLike(filterAb04b73s00, jqGridRequestDto,
				false);
		Long recordNum = this.ab04b73s00Dao
				.findAllLikeCount(filterAb04b73s00 != null ? filterAb04b73s00 : new ApartadoAnexoI(), false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<ApartadoAnexoI>> reorderSelection = this.ab04b73s00Dao.reorderSelection(filterAb04b73s00,
					jqGridRequestDto, startsWith);
			return new JQGridResponseDto<ApartadoAnexoI>(jqGridRequestDto, recordNum, listaAb04b73s00,
					reorderSelection);
		}
		return new JQGridResponseDto<ApartadoAnexoI>(jqGridRequestDto, recordNum, listaAb04b73s00);
	}

	/**
	 * Searches rows in the Ab04b73s00 table.
	 * 
	 *  filterAb04b73s00
	 *            Ab04b73s00
	 *  searchAb04b73s00
	 *            Ab04b73s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<TableRowDto<Ab04b73s00>>
	 *
	 * @param filterAb04b73s00 the filter ab 04 b 73 s 00
	 * @param searchAb04b73s00 the search ab 04 b 73 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<TableRowDto<ApartadoAnexoI>> search(ApartadoAnexoI filterAb04b73s00, ApartadoAnexoI searchAb04b73s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.ab04b73s00Dao.search(filterAb04b73s00, searchAb04b73s00, jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in Ab04b73s00 table.
	 * 
	 *  filterAb04b73s00
	 *            Ab04b73s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  Object
	 *
	 * @param filterAb04b73s00 the filter ab 04 b 73 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the object
	 */
	public Object reorderSelection(ApartadoAnexoI filterAb04b73s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		return this.ab04b73s00Dao.reorderSelection(filterAb04b73s00, jqGridRequestDto, startsWith);
	}

}
